from dataclasses import dataclass


@dataclass(frozen=True)
class LogbrokerEndpoint:
    host: str
    port: int

    def __str__(self) -> str:
        return f'{self.host}:{self.port}'

    def __repr__(self) -> str:
        return f'{self.__class__.__name__}({self.host}:{self.port})'


def get_one_of(message, attribute):
    present_field = message.WhichOneof(attribute)
    return getattr(message, present_field)
