from typing import Mapping, List, NewType, Union, Callable
from logbroker.public.api.protos.config_manager_pb2 import (
    DescribeAccountResult, DescribeDirectoryResult, DescribeTopicResult
)
from saas.library.python.logbroker.client import TServiceClass, LogbrokerClient
from saas.library.python.logbroker.configuration.directory import LogbrokerDirectory
from saas.library.python.logbroker.configuration.entities import LogbrokerConsumer
from saas.library.python.logbroker.configuration.topic import LogbrokerTopic

PathString = NewType('PathString', str)

class ConfigurationClient(LogbrokerClient):
    _ENTITY_TYPE_MAPPING: Mapping[str, Callable] = ...

    @property
    def _service_stub_cls(self) -> TServiceClass: ...

    async def list_directory(self, path: PathString) -> List[Union[LogbrokerTopic, LogbrokerConsumer, LogbrokerDirectory]]: ...

    async def list_topics(self, path: PathString, recurse: bool=False) -> List[LogbrokerTopic]: ...

    async def describe_path(self, path: PathString) -> Union[DescribeTopicResult, DescribeDirectoryResult, DescribeAccountResult]: ...
