from logbroker.public.api.protos.config_manager_pb2 import CreateDirectoryRequest, SingleModifyRequest
from logbroker.public.api.protos.common_pb2 import Path, IntOrDefaultValue, StringOrDefaultValue, DirectoryProperties
from saas.library.python.logbroker.configuration.entities import LogbrokerEntity


class LogbrokerDirectory(LogbrokerEntity):
    _PROP_TYPE_MAPPING = {
        'abc_service': StringOrDefaultValue,
        'abc_id': IntOrDefaultValue,
        'responsible': StringOrDefaultValue,
        'mailing_list': StringOrDefaultValue
    }
    _PROP_CLASS = DirectoryProperties

    @classmethod
    def make_create_request(cls, path, **properties):
        return SingleModifyRequest(
            create_directory=CreateDirectoryRequest(path=Path(path=path), properties=cls._fill_properties(**properties))
        )
