class LogbrokerEntity(object):
    _PROP_TYPE_MAPPING = {}
    _PROP_CLASS = None

    def __init__(self, logbroker_client, path):
        self._logbroker_client = logbroker_client
        self.path = path

    def __repr__(self):
        return f'{self.__class__.__name__}({self.path})'

    def __str__(self):
        return self.path

    @classmethod
    def _fill_properties(cls, **kwargs):
        prop_dict = {}
        for k, v in kwargs.items():
            prop_message_class = cls._PROP_TYPE_MAPPING[k]
            if isinstance(v, list):
                value = ','.join(v)
            else:
                value = v

            prop_message = prop_message_class(user_defined=value)
            prop_dict[k] = prop_message
        return cls._PROP_CLASS(**prop_dict)

    async def describe(self) -> None:
        return await self._logbroker_client.describe_path(self.path)


class LogbrokerConsumer(LogbrokerEntity):
    ...
