# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from typing import AnyStr, Optional, List, Type

from infra.nanny.yp_lite_api.proto.endpoint_sets_pb2 import EndpointSet as ProtoEndpointSet
from infra.nanny.yp_lite_api.py_stubs.endpoint_sets_api_stub import YpLiteUIEndpointSetsServiceStub

from .rpc_client_base import NannyRpcClientBase


class EndpointSet(NannyRpcClientBase):
    _identity: List[str]
    _RPC_URL: str
    _API_STUB: Type[YpLiteUIEndpointSetsServiceStub]
    _CLIENT: YpLiteUIEndpointSetsServiceStub

    def __init__(self, cluster: AnyStr, endpoint_set_id: AnyStr, proto_msg: Optional[ProtoEndpointSet]=None) -> None:
        super(EndpointSet, self).__init__()
        self._cluster = cluster
        self._id = endpoint_set_id
        self._proto_msg = proto_msg

    @classmethod
    def create(cls, cluster: List[AnyStr], service_id: AnyStr, endpoint_set_id: AnyStr, pod_filter: AnyStr='', protocol: AnyStr = 'tcp', port: int = 80, description: AnyStr = '') -> List[EndpointSet]: ...

    @classmethod
    def search(cls, cluster: AnyStr, substring: AnyStr, limit: int=100) -> List[EndpointSet]: ...

    @classmethod
    def list(cls, cluster: AnyStr, service_id: AnyStr) -> List[EndpointSet]: ...

    @property
    def cluster(self) -> str: ...

    @property
    def id(self) -> str: ...

    @property
    def proto_msg(self) -> ProtoEndpointSet: ...

    @property
    def service_id(self) -> str: ...

    @property
    def version(self) -> str: ...

    @property
    def pod_filter(self) -> str: ...

    @property
    def protocol(self) -> str: ...

    @property
    def description(self) -> str: ...

    def update(self, pod_filter: AnyStr = '', protocol: AnyStr = 'tcp', port: int = 80, description: AnyStr = '') -> None: ...

    def remove(self) -> None: ...

    @pod_filter.setter
    def pod_filter(self, value: AnyStr) -> None: ...

    @protocol.setter
    def protocol(self, value: AnyStr) -> None: ...

    @description.setter
    def description(self, value: AnyStr) -> None: ...
