# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from nanny_rpc_client.exceptions import ConflictError


class NannyProtoClientError(Exception):
    def __init__(self, *args, **kwargs):
        self.request = None
        self.inner_exception = None
        if 'request' in kwargs:
            self.request = kwargs.pop('request')
        if 'inner_exception' in kwargs:
            self.inner_exception = kwargs.pop('inner_exception')

        super(NannyProtoClientError, self).__init__(*args, **kwargs)


class EndpointSetApiError(NannyProtoClientError):
    def __init__(self, *args, **kwargs):
        super(EndpointSetApiError, self).__init__(*args, **kwargs)


class VersionConflictError(EndpointSetApiError, ConflictError):
    def __init__(self, *args, **kwargs):
        super(VersionConflictError, self).__init__(*args, **kwargs)


class ApiRequestTimeout(NannyProtoClientError):
    pass
