# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from typing import AnyStr, Optional, List, Type, Dict, NoReturn, Pattern
from infra.nanny.yp_lite_api.py_stubs.pod_sets_api_stub import YpLiteUIPodSetsServiceStub

from .rpc_client_base import NannyRpcClientBase


class Pod(NannyRpcClientBase):
    _identity: List[str]
    _RPC_URL: str
    _API_STUB: Type[YpLiteUIPodSetsServiceStub]
    _CLIENT: YpLiteUIPodSetsServiceStub
    _POD_FQDN_REGEXP: Pattern

    @staticmethod
    def _patch_dict(d: Dict, update: Dict) -> Dict: ...

    def __init__(self, cluster, pod_id, proto_msg=None):
        super(Pod, self).__init__()
        self._cluster = cluster
        self._id = pod_id
        self._proto_msg = proto_msg

    @classmethod
    def from_fqdn(cls, fqdn: AnyStr) -> Pod: ...

    @classmethod
    def list(cls, cluster: AnyStr, service_id: AnyStr, limit: int = 500, offset: int = 0) -> List[Pod]:
        """
        :param cluster: YP Lite cluster name, ex: SAS
        :param service_id: Nanny service id (name)
        :param limit: maximum number of returned pods (1-500)
        :param offset: pagination offset (0-100000)
        """
    ...

    @property
    def cluster(self) -> str: ...

    @property
    def id(self) -> str: ...

    @property
    def service_id(self) -> str: ...

    @property
    def proto_msg(self): ...

    @property
    def labels(self) -> Dict[str, str]: ...

    @labels.setter
    def labels(self, value: Dict[AnyStr, AnyStr]) -> NoReturn: ...

    @property
    def annotations(self) -> Dict[str, str]: ...

    @annotations.setter
    def annotations(self, value: Dict[AnyStr, AnyStr]) -> NoReturn: ...

    @property
    def version(self) -> str: ...

    def update_labels(self, **kwargs: AnyStr) -> NoReturn: ...

    def update_annotations(self, **kwargs: AnyStr) -> NoReturn: ...

    def update(self, labels: Optional[Dict[AnyStr, Optional[AnyStr]]] = None, annotations: Optional[Dict[AnyStr, Optional[AnyStr]]] = None) -> NoReturn: ...
