# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

import logging
from saas.library.python.nanny_rest.enums import SnapshotStatus


class CmsSnapshotInfo(object):
    LOGGER = logging.getLogger(__name__)
    """
    Dataclass for rest representation of
    https://a.yandex-team.ru/arc_vcs/infra/nanny/nanny_repo/nanny_repo/repo.proto?rev=r9053774#L721
    in rest interface some fields renamed:
        id -> snapshot_id
        last_transition_time -> entered
        status -> state
    """
    __slots__ = ('nanny_service', 'snapshot_id', 'state', 'prepared', 'conf_id', 'taskgroup_id', 'taskgroup_started')

    def __init__(self, nanny_service, **kwargs):
        self.nanny_service = nanny_service
        extra_kwargs = {}
        for k, v in kwargs.items():
            if k in self.__slots__:
                if k == 'state':
                    setattr(self, k, SnapshotStatus(v))
                else:
                    setattr(self, k, v)
            else:
                extra_kwargs[k] = v
        if extra_kwargs:
            self.LOGGER.error('Extra fields in snapshot info for %s: %s', nanny_service, extra_kwargs)
