# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

import logging
from infra.nanny.nanny_services_rest.nanny_services_rest.client import ServiceRepoClient
from saas.library.python.token_store import PersistentTokenStore


class NannyDashboard(object):
    LOGGER = logging.getLogger(__name__)
    _NANNY = None

    @classmethod
    def initialize_nanny_client(cls):
        if cls._NANNY is None:
            cls.LOGGER.debug('Initializing nanny service repo client')
            cls._NANNY = ServiceRepoClient(
                'https://nanny.yandex-team.ru', token=PersistentTokenStore.get_token_from_store_env_or_file('nanny')
            )

    def __str__(self):
        return 'NannyDashboard({})'.format(self.groups)

    def __repr__(self):
        return 'NannyDashboard({})'.format(self.id)

    def __init__(self, dashboard_id):
        self.id = dashboard_id
        self.initialize_nanny_client()
        response_content = self._NANNY.get_dashboard(dashboard_id)['con']
        self.owners = response_content['owners']
        self.labels = response_content['labels']
        self.managers = response_content['managers']
        self.name = response_content['name']
        self.allow_updating_auto_scheduled_services = response_content['allow_updating_auto_scheduled_services']
        self.enable_authorization = response_content['enable_authorization']
        self.groups = {g['id']: [s['service_id'] for s in g['services']] for g in response_content['groups']}
