# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from enum import Enum


class AllocationType(Enum):
    gencfg = 'EXTENDED_GENCFG_GROUPS'
    yp_lite = 'YP_POD_IDS'


class ServiceSummaryStatus(Enum):
    # https://a.yandex-team.ru/arc_vcs/infra/nanny/nanny_repo/nanny_repo/repo.proto?rev=r9053094#L778
    OFFLINE = 'OFFLINE'
    ONLINE = 'ONLINE'
    UPDATING = 'UPDATING'
    SHUTTING_DOWN = 'SHUTTING_DOWN'
    BROKEN = 'BROKEN'
    PREPARING = 'PREPARING'


class SnapshotStatus(Enum):
    GENERATING = 'GENERATING'
    ACTIVATING = 'ACTIVATING'
    DEACTIVATING = 'DEACTIVATING'
    ACTIVE = 'ACTIVE'
    BROKEN = 'BROKEN'
    PREPARING = 'PREPARING'
    PARTIALLY_PREPARED = 'PARTIALLY_PREPARED'
    PREPARED = 'PREPARED'
    REMOVING = 'REMOVING'
    DESTROYING = 'DESTROYING'
    PARTIALLY_CREATED = 'PARTIALLY_CREATED'
    CREATED = 'CREATED'
    DEACTIVATE_PENDING = 'DEACTIVATE_PENDING'
    DESTROYED = 'DESTROYED'
    ACTIVATION_MUST_BE_CANCELLED = 'ACTIVATION_MUST_BE_CANCELLED'
