# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


class NannyApiError(Exception):
    def __init__(self, *args, **kwargs):
        if 'inner_exception' in kwargs:
            self.inner_exception = kwargs.pop('inner_exception')
        super(NannyApiError, self).__init__(*args, **kwargs)

    def __str__(self):
        if hasattr(self, 'inner_exception'):
            return '{}({})'.format(self.__class__.__name__, self.inner_exception)
        else:
            super(NannyApiError, self).__str__()


class NannyServiceNotFoundError(NannyApiError):
    pass


class NannyServiceAlreadyExists(NannyApiError):
    pass


class ConcurrentModificationError(NannyApiError):
    pass


class InvalidRecipe(NannyApiError):
    pass
