# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from collections import namedtuple


class AuthConfig(namedtuple('AuthConfig', ('logins', 'groups'))):
    __slots__ = ()

    def content(self):
        return {
            'logins': self.logins,
            'groups': self.groups
        }

    def ensure_login(self, login):
        if login not in self.logins:
            self.logins.append(login)


class NannyServiceBaseAuthProxy(object):
    def __init__(self, initial_state):
        self._auth_attrs = initial_state
        self.owners = AuthConfig(**self._auth_attrs.pop('owners'))
        self.observers = AuthConfig(**self._auth_attrs.pop('observers'))
        self.ops_managers = AuthConfig(**self._auth_attrs.pop('ops_managers'))
        self.conf_managers = AuthConfig(**self._auth_attrs.pop('conf_managers'))

    @property
    def auth_attrs_content(self):
        base_dict = self._auth_attrs
        base_dict['owners'] = self.owners.content()
        base_dict['observers'] = self.observers.content()
        base_dict['ops_managers'] = self.ops_managers.content()
        base_dict['conf_managers'] = self.conf_managers.content()
        return base_dict
