from typing import NamedTuple, List, AnyStr, Dict

AuthAttrs = Dict[str, Dict[str, List[str]]]

class AuthConfig(NamedTuple):
    logins: List[AnyStr]
    groups: List[AnyStr]

    def content(self) -> Dict[str, List[str]]: ...
    def ensure_login(self, login: str): ...

class NannyServiceBaseAuthProxy(object):
    def __init__(self, initial_state: AuthAttrs):
        self._auth_attrs = initial_state
        self.owners: AuthConfig = ...
        self.observers: AuthConfig = ...
        self.ops_managers: AuthConfig = ...
        self.conf_managers: AuthConfig = ...

    @property
    def auth_attrs_content(self) -> AuthAttrs: ...
