from typing import AnyStr, Dict, Union, Iterable, List, Any

from saas.library.python.nanny_rest.recipe import AlemateRecipe
from saas.library.python.nanny_rest.tickets_integration.tickets_integration import TicketsIntegration

InfoAttributes = Dict[AnyStr, Union[List, int, AnyStr, Dict[AnyStr, Any]]]

class NannyServiceBaseInfoProxy(object):
    def __init__(self, initial_state: InfoAttributes):
        self._info_attrs = initial_state
        self.category: str = self._info_attrs.pop('category')
        self.abc_group: int = self._info_attrs.pop('abc_group')
        self.description: str = self._info_attrs.pop('desc')
        self.tickets_integration: TicketsIntegration = ...
        self.labels: Dict[AnyStr, AnyStr] = ...

    @property
    def info_attrs_content(self) -> InfoAttributes: ...

    @property
    def recipes(self) -> Dict[str, AlemateRecipe]: ...

    @recipes.setter
    def recipes(self, value: Dict[str, AlemateRecipe]): ...

    @property
    def prepare_recipes(self) -> Dict[str, AlemateRecipe]: ...

    @prepare_recipes.setter
    def prepare_recipes(self, value: Dict[str, AlemateRecipe]): ...

    def add_or_update_recipe(self, recipe: AlemateRecipe): ...

    def add_or_update_recipes(self, recipes: Iterable[AlemateRecipe]): ...

    def add_or_update_prepare_recipe(self, recipe: AlemateRecipe): ...

    def add_or_update_prepare_recipes(self, recipes: Iterable[AlemateRecipe]): ...
