from typing import AnyStr, Dict, Sequence, Union, Iterable, List, Any

from saas.library.python.nanny_rest.service import NannyServiceBase
from saas.library.python.nanny_rest.enums import AllocationType
from saas.library.python.nanny_rest.resource import SandboxFile, StaticFile, UrlFile, TemplateSetFile
from saas.library.python.nanny_rest.shard_resource import RegisteredShard, SandboxShard, SandboxShardmap
from saas.library.python.nanny_rest.service_mutable_proxy.instance_spec import InstanceSpec

RuntimeAttributes = Dict[AnyStr, Dict[AnyStr: Union[AnyStr, List, Dict[AnyStr, Any]]]]
NormalResources = Union[List[SandboxFile], List[StaticFile], List[UrlFile], List[TemplateSetFile]]
ShardmapResource = Union[RegisteredShard, SandboxShard, SandboxShardmap]

class NannyServiceBaseRuntimeProxy(object):
    def __init__(self, nanny_service, initial_state: RuntimeAttributes):
        self.nanny_service: NannyServiceBase = nanny_service
        self._runtime_attrs = initial_state

        self.instance_spec: InstanceSpec = ...

        self._resources: Dict[AnyStr, Union[SandboxShardmap, NormalResources]] = ...
        self._extra_resources: Dict[AnyStr, List[Dict]] = ...

    @property
    def runtime_attrs_content(self) -> RuntimeAttributes: ...

    # Runtime attributes
    @property
    def allocation_type(self) -> AllocationType: ...

    @allocation_type.setter
    def allocation_type(self, value: AllocationType): ...

    @property
    def resources(self) -> Dict[AnyStr, Union[SandboxShardmap, NormalResources]]: ...

    def set_resource(self, resource: Union[SandboxFile, StaticFile, UrlFile, TemplateSetFile]): ...

    # Specific resources
    @property
    def sandbox_files(self) -> Sequence[SandboxFile]: ...

    @sandbox_files.setter
    def sandbox_files(self, value: Iterable[SandboxFile]): ...

    @property
    def static_files(self) -> Sequence[StaticFile]: ...

    @static_files.setter
    def static_files(self, value: Iterable[StaticFile]): ...

    @property
    def url_files(self) -> Sequence[UrlFile]: ...

    @url_files.setter
    def url_files(self, value: Iterable[UrlFile]): ...

    @property
    def template_set_files(self) -> Sequence[TemplateSetFile]: ...

    @template_set_files.setter
    def template_set_files(self, value: Iterable[TemplateSetFile]): ...

    @property
    def shard(self) -> Union[None, RegisteredShard, SandboxShard, SandboxShardmap]: ...

    @shard.setter
    def shard(self, value: Union[RegisteredShard, SandboxShard, SandboxShardmap]): ...
