# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

import json

from saas.library.python.nanny_rest.tickets_integration.enums import SchedulingPriority


class AutocommitSettings(object):
    __slots__ = ('enabled', 'scheduling_priority', 'mark_as_disposable')

    def __init__(self, enabled=False, scheduling_priority=SchedulingPriority.none, mark_as_disposable=False):
        self.enabled = enabled
        self.scheduling_priority = SchedulingPriority(scheduling_priority)
        self.mark_as_disposable = mark_as_disposable

    def dict(self):
        return {
            'enabled': self.enabled,
            'scheduling_priority': self.scheduling_priority.value,
            'mark_as_disposable': self.mark_as_disposable
        }

    def __eq__(self, other):
        if self.enabled:
            if other is None or not other.enabled:
                return False
            else:
                return (self.scheduling_priority == other.scheduling_priority and
                        self.mark_as_disposable == other.mark_as_disposable)
        else:
            if other is None or not other.enabled:
                return True
            else:
                return False

    def __str__(self):
        return json.dumps(self.dict())

    def __repr__(self):
        return 'AutocommitSettings({}, {}, {})'.format(
            self.enabled, self.scheduling_priority, self.mark_as_disposable
        )
