# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

import six
from enum import Enum


class ExtendedEnum(Enum):
    @classmethod
    def build(cls, value):
        if isinstance(value, cls):
            return value
        elif isinstance(value, six.string_types):
            return cls(cls._build_from_str(value))
        else:
            raise ValueError

    @staticmethod
    def _build_from_str(s):
        return s.lower()


class TicketPriority(ExtendedEnum):
    normal = 'NORMAL'
    high = 'HIGH'

    @staticmethod
    def _build_from_str(s):
        return s.upper()


class SchedulingPriority(ExtendedEnum):
    none = 'NONE'           # Do not schedule automatically
    normal = 'NORMAL'       # Wait until service is ONLINE
    critical = 'CRITICAL'   # Schedule as soon as possible

    @staticmethod
    def _build_from_str(s):
        return s.upper()


class ReleaseType(ExtendedEnum):
    stable = 'stable'
    prestable = 'prestable'
    testing = 'testing'
    unstable = 'unstable'

    @staticmethod
    def _build_from_str(s):
        return s.lower()
