# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from saas.library.python.nanny_rest.tickets_integration.enums import ReleaseType
from saas.library.python.nanny_rest.tickets_integration.autocommit_settings import AutocommitSettings
from saas.library.python.nanny_rest.tickets_integration.tickets_integration_rule import TicketsIntegrationRule


class InstancectlReleaseRule(object):
    __slots__ = ('enabled', 'responsibles', 'auto_commit_settings', 'match_release_type', 'queue_id')

    def __init__(self, match_release_type='-', auto_commit_settings=AutocommitSettings(),
                 queue_id='INSTANCECTL', responsibles=None):
        if match_release_type == '-':
            self.enabled = False
            self.match_release_type = '-'
        else:
            self.enabled = True
            if isinstance(match_release_type, ReleaseType):
                self.match_release_type = match_release_type.value.upper()
            else:
                self.match_release_type = match_release_type

        if isinstance(auto_commit_settings, AutocommitSettings):
            self.auto_commit_settings = auto_commit_settings
        else:
            self.auto_commit_settings = AutocommitSettings(**auto_commit_settings)

        self.responsibles = responsibles if responsibles else TicketsIntegrationRule.default_responsibles
        self.queue_id = queue_id if queue_id else 'INSTANCECTL'

    def dict(self):
        return {
            'responsibles': self.responsibles,
            'auto_commit_settings': self.auto_commit_settings.dict(),
            'match_release_type': self.match_release_type,
            'queue_id': self.queue_id
        }

    def enable(self, release_type, autocommit=AutocommitSettings(), queue_id='INSTANCECTL', responsibles=None):
        if not isinstance(release_type, ReleaseType):
            raise ValueError('Invalid value {} for release_type'.format(release_type))
        self.enabled = True
        self.match_release_type = release_type.value.upper()
        self.auto_commit_settings = autocommit
        self.responsibles = responsibles if responsibles else TicketsIntegrationRule.default_responsibles
        self.queue_id = queue_id if queue_id else 'INSTANCECTL'

    def disable(self):
        self.enabled = False
        self.match_release_type = '-'
