# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


class PortRange(object):
    __slots__ = ('lower_port', 'upper_port')

    def __init__(self, lower_port, upper_port=None):
        if upper_port is not None and int(upper_port) < int(lower_port):
            raise ValueError('Upper port lower then lower')
        self.lower_port = int(lower_port)
        self.upper_port = int(upper_port) if upper_port is not None else int(lower_port)

    def __eq__(self, other):
        return self.lower_port == other.lower_port and self.upper_port == other.upper_port

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return '{}-{}'.format(self.lower_port, self.upper_port) if self.upper_port > self.lower_port else str(self.lower_port)

    def __repr__(self):
        return 'PortRange({}, {})'.format(self.lower_port, self.upper_port)

    @classmethod
    def from_str(cls, s):
        str_list = s.strip().split('-')
        if len(str_list) > 2:
            raise ValueError('{} is not valid PortRange')
        else:
            return cls(*str_list)
