import datetime
from typing import AnyStr, List, Optional, NamedTuple
from .enums import Protocol, Location
from .port_range import PortRange


class Rule(NamedTuple):
    id: AnyStr
    sources: List[AnyStr]
    destinations: List[AnyStr]
    protocol: Protocol
    ports: List[PortRange]
    locations: Optional[List[Location]]
    until: Optional[datetime.datetime]
    task: Optional[AnyStr]
    added: datetime.datetime
    updated: datetime.datetime
