import datetime
from typing import AnyStr, List, Optional, Dict, Union, NamedTuple

from .enums import Protocol, Location, RequestStatus
from .port_range import PortRange


class RuleRequest(NamedTuple):
    # Params for new requests to be created
    sources: List[AnyStr]
    destinations: List[AnyStr]
    protocol: Protocol
    ports: List[PortRange]
    locations: Optional[List[Location]] = None
    until: Optional[datetime.datetime] = None
    comment: AnyStr = None

    # Fields of already created requests
    id: Optional[AnyStr] = None
    rule_id: Optional[AnyStr] = None
    type: Optional[AnyStr] = None
    status: Optional[RequestStatus] = None
    author: Optional[Dict[AnyStr, Union[AnyStr, Dict, bool]]] = None
    task: Optional[AnyStr] = None
    sibdiscussion: Optional[bool] = None
    responsiblediscussion: Optional = None
    system: Optional[AnyStr] = None
    added: Optional[datetime.datetime] = None
    updated: Optional[datetime.datetime] = None
    responsibles: List[Optional[Dict[AnyStr, Union[AnyStr, Dict, bool]]]] = None
    can_reject: Optional[bool] = None
    can_approve: Optional[bool] = None

    def request_dict(self) -> Dict[str, Union[Protocol, datetime.datetime, List[AnyStr], List[PortRange], List[Location]]]: ...
