# coding: utf-8

"""
Simple client for racktables project networks api at https://racktables.yandex-team.ru/export/project-id-networks.php

Oauth token url: https://oauth.yandex-team.ru/authorize?response_type=token&client_id=4ae71bc12f4044b1ac9055efb0801c54

ProjectNetworksApi requires outh token, it may be provided via
- Explict init, ex: ProjectNetworksApi(oauth_token='AQAD-...')
- Explict in TokenStore, example:
    >>> from saas.library.python.token_store import TokenStore
    >>> TokenStore.add_token('racktables', 'AQAD-...')
    >>> ProjectNetworksApi()  # will use Oauth token from TokenStore
- Environment variables, environment variables checked by TokenStore are OAUTH_RACKTABLES, RACKTABLES_OAUTH, RACKTABLES_OAUTH_TOKEN

Example usage:
        >>> from saas.library.python.racktables import ProjectNetworksApi
        >>>
        >>> racktables = ProjectNetworksApi()  # Pretend we have oauth token in ENV
        >>> new_macro = racktables.create_macro(
        >>>     '_SAAS_TEST_NETWORK_', owners=('svc_saas_administration', 'salmin', 'coffeeman', 'i024', 'saku'), parent='_SAAS_BASE_NETS_', description='Just a test'
        >>> )
        >>> racktables.create_network(new_macro.name)  # YP can't allocate networks itself yet
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from .project_networks import ProjectNetworksApi

__all__ = [ProjectNetworksApi, ]
