# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


class RacktablesError(Exception):
    """Base class for module errors"""


class ProjectNetworksApiError(RacktablesError):
    """Generic ProjectNetworksApi errors"""
    def __init__(self, *args, **kwargs):
        self.inner_exception = kwargs.pop('inner_exception', None)
        super(ProjectNetworksApiError, self).__init__(*args, **kwargs)

    def __str__(self):
        return 'ProjectNetworksApiError({})'.format(self.inner_exception)


class UnknownMacro(ProjectNetworksApiError):
    def __init__(self, *args, **kwargs):
        super(UnknownMacro, self).__init__(*args, **kwargs)
