# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from six import string_types
from collections import namedtuple


class NetworkMacro(namedtuple('NetworkMacro', ('ids', 'name', 'owners', 'owner_service', 'parent', 'description', 'internet', 'secured', 'can_create_network'))):
    __slots__ = ()

    @property
    def networks(self):
        return self.ids

    def __str__(self):
        return self.name

    def __eq__(self, other):
        if isinstance(other, string_types):
            return self.name == other
        else:
            return self.name == other.name
