# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from enum import Enum
from requests import Session
from typing import AnyStr, Sequence, Dict, Union, List, Optional, Pattern
from logging import Logger
from .network_macro import NetworkMacro

class Operations(Enum):
    ...

class ProjectNetworksApi(object):
    BASE_URL: AnyStr
    LOGGER: Logger = ...
    _ERROR_REGEXP: Pattern

    def __init__(self, oauth_token: AnyStr = None):
        self._session: Session = ...

    def _make_request(self, operation: Operations, **kwargs) -> Dict: ...

    @staticmethod
    def _normalise_owners(owners: Optional[Union[AnyStr, Sequence]]) -> Optional[AnyStr]: ...

    def list_macros(self) -> List[NetworkMacro]:
        """
        :return: List of all network macros ! Order is not persistent ! Long request. Response size > 10MB !
        """
        ...

    def list_ranges(self) -> Dict[AnyStr, Dict[AnyStr, Dict]]: ...


    def show_macro(self, name: AnyStr) -> NetworkMacro:
        """
        :param name: Name of network macro, ex: _MY_USELESS_NETS_
        :return: Requested macro
        """
        ...

    def macro_exists(self, name: AnyStr) -> bool:
        ...

    def create_macro(self, name: AnyStr, owner_service: AnyStr, owners: Union[AnyStr, Sequence[AnyStr]], parent: AnyStr, description: AnyStr, secured: int = 0) -> NetworkMacro:
        """
        :param name: Name of network macro, ex: _MY_NEW_MACRO_
        :param owner_service: ABC service slug in staff notation, ex: svc_saas
        :param owners: List of owners in form of list or comma separated string. Can contain users, staff groups and ABC services/roles, ex: ['salmin', 'yandex_search_tech_quality_robot_saas', 'svc_saas_administration']
        :param parent: Name of parent macro or None
        :param description: Description for macro
        :param secured: set 1 to forbid using macro in qloud,rtc,deploy,etc..
        :return: Created macro
        """
        ...

    def edit_macro(self, name: AnyStr, owner_service: AnyStr, owners: Optional[Union[AnyStr, Sequence[AnyStr]]] = None, parent: Optional[AnyStr] = None, description: Optional[AnyStr] = None) -> NetworkMacro:
        """
        Update specified attributes of network macro
        :param name: Name of network macro, ex: _MY_MACRO_
        :param owner_service: ABC service slug in staff notation, ex: svc_saas
        :param owners: List of owners in form of list or comma separated string. Can contain users, staff groups and ABC services/roles, ex: ['salmin', 'yandex_search_tech_quality_robot_saas', 'svc_saas_administration']
        :param parent: Name of parent macro
        :param description: Text description
        :return: Updated macro
        """
        ...

    def delete_macro(self, name: AnyStr) -> List:
        """
        :param name: Name of network macro to delete, ex: _MY_USELESS_NETS_
        :return: List of warnings (should be empty)
        """
        ...

    def create_network(self, macro_name: AnyStr, scope: AnyStr = None, project_id: AnyStr = None, description: AnyStr = None) -> NetworkMacro:
        """
        :param macro_name: Macro name to add network to
        :param scope: Network scope (Null scope is default)
        :param project_id: create network with this ID
        :param description: Network description
        :return: Updated network macro
        """
        ...

    def delete_network(self, project_id: AnyStr, macro_name: AnyStr, scope: AnyStr = None) -> NetworkMacro:
        """
        :param project_id: Delete network with this project id
        :param macro_name: Name of network macro with network
        :param scope: Network scope (Null scope is default)
        :return: Updated network macro
        """
        ...

    def move_network(self, project_id: AnyStr, macro_name: AnyStr, scope: AnyStr = None) -> NetworkMacro:
        """
        :param project_id: Project id to move
        :param macro_name: Target macro name
        :param scope: Network scope (Null scope is default)
        :return: Updated target macro
        """
        ...
