from typing import Any, AnyStr, List, Optional, Mapping, Iterator, Union

from logging import Logger
from sandbox.common.rest import Client

from saas.library.python.sandbox.task import SandboxTask
from saas.library.python.sandbox.resource import SandboxResource
from saas.library.python.sandbox.scheduler import SandboxScheduler, SchedulerStatus


class SandboxApi(object):
    LOGGER: Logger

    def __init__(self, oauth_token: AnyStr = None):
        self.sandbox_client: Client = ...

    def task_by_id(self, task_id: int) -> SandboxTask: ...

    def resource_by_id(self, resource_id: int) -> SandboxResource: ...

    def scheduler_by_id(self, scheduler_id: int) -> SandboxScheduler: ...

    def find_resources(self, resource_type: AnyStr=None, state: AnyStr=None, **kwargs) -> List[SandboxResource]: ...

    def get_last_released_resource(self, resource_type: AnyStr) -> SandboxResource: ...

    def find_schedulers(self, task_type: Optional[str] = None, tags: Optional[List[str]] = None,
                        status: Optional[Union[SchedulerStatus, List[SchedulerStatus]]] = None,
                        owner: Optional[str] = None, author: Optional[str] = None, all_tags: bool = False,
                        order: Optional[str] = None, limit: int = 20,
                        full_info: bool = False, **kwargs) -> Iterator[SandboxScheduler]: ...

    def add_task(self, task_type: AnyStr, task_owner: AnyStr, task_params: Mapping[AnyStr, Any], description: AnyStr='',
                 notifications=None) -> SandboxTask: ...

    def add_scheduler(self,
                      task_type: AnyStr,
                      owner: AnyStr,
                      scheduler_params: Mapping[AnyStr, Any],
                      task_params: Mapping[AnyStr, Any],
                      description: AnyStr = '',
                      scheduler_notifications=None,
                      task_notifications=None,
                      task_priority: AnyStr = 'BACKGROUND:LOW',
                      task_tags: List[AnyStr] = None) -> SandboxScheduler: ...

    def update_scheduler(self,
                         scheduler_id: int,
                         scheduler_params: Mapping[AnyStr, Any],
                         task_params: Mapping[AnyStr, Any],
                         description: AnyStr = '',
                         scheduler_notifications=None,
                         task_notifications=None,
                         task_tags: List[AnyStr] = None) -> None: ...

    def delete_scheduler(self, scheduler_id: int) -> None: ...
