# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


class SandboxExecutorException(Exception):
    pass


class SandboxTaskFailure(SandboxExecutorException):
    def __init__(self, message, sandbox_task, *args):
        super(SandboxTaskFailure, self).__init__(message, *args)
        self.message = message
        self.sandbox_task = sandbox_task
        self.sandbox_exceptions = sandbox_task.context.get('exceptions', None)
        self.info = sandbox_task.sandbox_client.task[sandbox_task.id].read()['results']['info']
