from typing import Mapping, Dict, Any, AnyStr

from sandbox.common.rest import Client

from saas.library.python.sandbox.task import SandboxTask

ResourceInfo = Dict[AnyStr, Any]


class SandboxResource(object):
    PROPERTIES: Mapping[str, str] = {'skynet_id', 'http', 'description', 'rights', 'url', 'file_name', 'sources', 'state', 'arch', 'time',
                  'owner', 'attributes', 'for_parent', 'size', 'type', 'md5'}

    def __str__(self) -> str: ...

    def __init__(self, sandbox: Client, resource_id: int, task: SandboxTask=None):
        self.sandbox_client: Client = sandbox
        self.id: int = resource_id
        self._task: SandboxTask = task
        self._info = Dict

    @classmethod
    def from_resource_info(cls, sandbox: Client, resource_info: ResourceInfo) -> SandboxResource: ...

    def update_info(self):
        """Update self from server"""
        ...

    @property
    def ready(self) -> bool: ...

    @property
    def task(self) -> SandboxTask: ...

    @property
    def content_skynet_url(self) -> str: ...

    @property
    def content_http_url(self) -> str: ...

    @property
    def content(self) -> bytes: ...

    @property
    def json_content(self) -> Dict:
        """Return parsed json content"""
        ...

    def nanny_resource_info(self) -> Dict[str, str]: ...
