from typing import Optional, Any, Dict
from logging import Logger
from datetime import datetime

from sandbox.common.rest import Client


class SandboxScheduler(object):
    LOGGER: Logger

    class Schedule(object):
        __slots__ = ...
        STR_FORMAT: str = ...

        def __init__(self, interval: int, start_time: Optional[datetime] = None, fail_on_error: bool = True,
                     retry_interval: Optional[int] = None, sequential_run: bool = False):
            self.repetition = {'interval': interval}
            self.start_time = start_time
            self.fail_on_error = fail_on_error
            self.retry = {'ignore': True, 'interval': retry_interval} if retry_interval else None
            self.sequential_run = sequential_run

        def dict(self) -> Dict[str, Any]: ...

        def __str__(self) -> str: ...

    @classmethod
    def from_scheduler_info(cls, sandbox: Client, scheduler_info: dict) -> SandboxScheduler: ...

    def __init__(self, sandbox: Client, scheduler_id: int):
        self.sandbox_client: Client = ...
        self.id: int = ...
        self._info: Optional[dict] = None
        ...

    def update_info(self): ...

    def start(self): ...

    def stop(self): ...
