# coding: utf-8
"""
Some sane retry strategies. Detailed documentation on Retry at https://urllib3.readthedocs.io/en/latest/reference/urllib3.util.html#module-urllib3.util.retry
Default DEFAULT_METHOD_WHITELIST https://urllib3.readthedocs.io/en/latest/reference/urllib3.util.html#urllib3.util.retry.Retry.DEFAULT_METHOD_WHITELIST
Sleep before next retry is computed as {backoff factor} * (2 ** ({number of total retries} - 1))
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


from requests.packages.urllib3.util.retry import Retry

DEFAULT_METHOD_WHITELIST = frozenset(['HEAD', 'TRACE', 'GET', 'OPTIONS', 'DELETE'])  # Remove PUT
RETRY_AFTER_STATUS_CODES = frozenset([503, 504, 529, 598, 408, 429])


def get_retry_strategy(
    total=10,
    connect=5,
    method_whitelist=DEFAULT_METHOD_WHITELIST,
    status_forcelist=RETRY_AFTER_STATUS_CODES,
    backoff_factor=1,
    respect_retry_after_header=True
):
    return Retry(
        total=total,   # successive sleeps before retry 0.5, 1, 2, 4, 8
        connect=connect,  # successive sleeps before retry 0.5, 1, 2, 4, 8
        method_whitelist=method_whitelist,
        status_forcelist=status_forcelist,
        backoff_factor=backoff_factor,
        respect_retry_after_header=respect_retry_after_header
    )
