# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


import requests

from .timeout_http_adapter import TimeoutHTTPAdapter
from .exponential_retry_strategy import get_retry_strategy


DEFAULT_RETRY_STRATEGY = get_retry_strategy()


def get_session(adapter=None, retry_strategy=DEFAULT_RETRY_STRATEGY):
    """
    :rtype: requests.Session
    """
    if adapter is None:
        adapter = TimeoutHTTPAdapter()
    adapter.max_retries = retry_strategy

    session = requests.Session()
    session.mount('http://', adapter)
    session.mount('https://', adapter)
    return session
