# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from requests.adapters import HTTPAdapter


DEFAULT_TIMEOUT = (0.06, 30)  # 60 ms connect timeout, 30 sec read timeout


class TimeoutHTTPAdapter(HTTPAdapter):
    def __init__(self, *args, **kwargs):
        self.timeout = DEFAULT_TIMEOUT
        if 'timeout' in kwargs:
            self.timeout = kwargs['timeout']
            del kwargs['timeout']
        super(TimeoutHTTPAdapter, self).__init__(*args, **kwargs)

    def send(self, request, **kwargs):
        timeout = kwargs.get('timeout')
        if timeout is None:
            kwargs['timeout'] = self.timeout
        return super(TimeoutHTTPAdapter, self).send(request, **kwargs)
