from typing import Tuple, Dict, Hashable, Any

import abc
import threading


class Singleton(abc.ABCMeta):
    _instances = Dict
    _locks: Dict[type, threading.Lock]

    def _get_instance_id(cls, args: Tuple, kwargs: Dict) -> Hashable: ...

    def __call__(cls, *args, **kwargs) -> Any: ...


class ThreadLocalSingleton(Singleton): ...


class InitSingleton(Singleton): ...


class DumbInitSingleton(InitSingleton): ...
