# coding: utf-8

from saas.library.python.token_store.token_store import TokenStore
from saas.library.python.token_store.persistent_token_store import PersistentTokenStore
from saas.library.python.token_store.errors import TokenStoreError
from .oauth_token_meta import OauthTokenMeta

__all__ = [
    TokenStore, PersistentTokenStore, OauthTokenMeta
]

"""
For scrips just use get_token(service)

For more complex situations:
Add tokens via TokenStore.add_token(service, token)
Add missing tokens via TokenStore.add_tokens_from_env()


ex:
required_clients = ('nanny', 'sandbox')
missing_tokens_message = 'Some tokens required for app are missing. Make sure you have set {}'.format(
  ' and '.join(['{}_OAUTH_TOKEN'.format(s.upper() for s in required_clients)])
  )
assert TokenStore.add_tokens_from_env().has_tokens_for(required_clients), missing_tokens_message
"""


def get_token(service):
    try:
        return PersistentTokenStore.get_token_from_store_env_or_file(service)
    except TokenStoreError:
        raise TokenStoreError('No token found for {}'.format(service))
