# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


class TokenStoreError(Exception):
    """Basic exception for token store"""


class TokenGetFail(TokenStoreError):
    """Base exception for fails in get_* methods"""


class TokenUpdateFail(TokenStoreError):
    """Base exception for fails in add_* and update_* methods"""


class TokenAlreadyExists(TokenUpdateFail):
    """Raised if service already have token in store """


class PersistentTokenStoreError(Exception):
    """Base exception for errors in persistent token storage"""


class TokenLoadError(PersistentTokenStoreError):
    """Raised in load operations if token file not readable or not exists"""


class TokenSaveError(PersistentTokenStoreError):
    """Raised in save operations if token file can't be written"""


class TokenConflictError(TokenSaveError):
    """Raised in save operations if token file can't be written"""
