# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

import abc
import six
import logging

from .persistent_token_store import PersistentTokenStore


class OauthTokenMeta(abc.ABCMeta):
    _OAUTH_SLUG = None

    def __call__(cls, *args, **kwargs):
        if getattr(cls, '_OAUTH_TOKEN', None):
            logging.debug('%s._OAUTH_TOKEN already set')
        else:
            if isinstance(cls._OAUTH_SLUG, six.string_types):
                cls._OAUTH_TOKEN = PersistentTokenStore.get_token_from_store_env_or_file(cls._OAUTH_SLUG)
            else:
                raise RuntimeError('{}._OAUTH_SLUG must be of string type'.format(cls))

        return super(OauthTokenMeta, cls).__call__(*args, **kwargs)
