# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from enum import Enum


class YasmPeriod(Enum):
    five_seconds = 5
    five_minutes = 5 * 60
    thirty_minutes = 30 * 60
    hour = 60 * 60
    three_hours = 3 * 60 * 60
    six_hours = 6 * 60 * 60
    twelve_hours = 12 * 60 * 60
    day = 24 * 60 * 60

    @classmethod
    def contains(cls, key):
        return key in [el.name for el in cls]


AGGREGATE_LAG = {
    YasmPeriod.five_seconds: 5 * YasmPeriod.five_seconds.value,
    YasmPeriod.five_minutes: 5 * YasmPeriod.five_minutes.value,
    YasmPeriod.thirty_minutes: YasmPeriod.thirty_minutes.value,
    YasmPeriod.hour: YasmPeriod.hour.value,
    YasmPeriod.three_hours: YasmPeriod.three_hours.value,
    YasmPeriod.six_hours: YasmPeriod.six_hours.value,
    YasmPeriod.twelve_hours: YasmPeriod.twelve_hours.value,
    YasmPeriod.day: YasmPeriod.day.value
}
