from typing import AnyStr, List, Generator, Tuple, Dict
from logging import Logger
from cached_property import cached_property
from saas.library.python.yasm.constants import YasmPeriod


class YasmSignal(object):
    LOGGER: Logger

    def __init__(self, signal: AnyStr, itype: AnyStr, **tags: AnyStr):
        self.signal: AnyStr = ...
        self._itype: AnyStr = ...
        self._tags: Dict[AnyStr, AnyStr] = ...

    @cached_property
    def tags_list(self) -> List[str]: ...

    @cached_property
    def tags_str(self) -> str: ...

    @classmethod
    def from_str(cls, yasm_str: AnyStr) -> YasmSignal: ...

    def iterate_rt(self, host: AnyStr = 'ASEARCH') -> Generator[Tuple[int, int], None, None]: ...

    def iterate_interval(
        self, period: YasmPeriod, interval_begin: int, interval_end: int, host='ASEARCH'
    ) -> Generator[Tuple[int, int], None, None]: ...

    def calculate_mean_over_interval(
        self, period: YasmPeriod, interval_begin: int, interval_end: int, host='ASEARCH', normalize=True
    ) -> float: ...

    def __str__(self) -> str: ...

    def __repr__(self) -> str: ...

    def __eq__(self, other): ...

    def __hash__(self): ...

    def __gt__(self, other): ...

    def __lt__(self, other): ...
