# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from cached_property import cached_property

from saas.library.python.yasm.signal import YasmSignal
from saas.library.python.yasm.constants import YasmPeriod

from typing import Dict, List, Generator, Tuple, Union, AnyStr, Set


SignalValues = Dict[str, Dict[str, Union[int, float, None]]]


class YasmSignalGroup(object):
    def __init__(self, *signals: Union[YasmSignal, AnyStr]):
        self._signals: Set = ...

    @cached_property
    def tags_signals(self) -> Dict[str, List[str]]: ...

    def iterate_rt(self, host: AnyStr = 'ASEARCH') -> Generator[Tuple[int, SignalValues], None, None]: ...

    def iterate_interval(
        self, period: YasmPeriod, interval_begin: int, interval_end: int, host: AnyStr = 'ASEARCH'
    ) -> Generator[Tuple[int, SignalValues], None, None]: ...

    def __repr__(self) -> str: ...

    def __eq__(self, other): ...
