# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

import six
from library.python.vault_client.instances import Production as VaultClient
from saas.library.python.token_store import PersistentTokenStore
from saas.library.python.singleton import Singleton


class YavClientFabric(six.with_metaclass(Singleton)):
    __slots__ = ()
    VAULT_CLIENT = None

    # OAUTH_URL = https://oauth.yandex-team.ru/authorize?response_type=token&client_id=ce68fbebc76c4ffda974049083729982
    @classmethod
    def get_yav_client(cls, decode_files=True, oauth=None):
        if cls.VAULT_CLIENT is None:
            if oauth is None:
                oauth = PersistentTokenStore.get_token_from_store_env_or_file('yav')
            cls.VAULT_CLIENT = VaultClient(decode_files=decode_files, authorization='OAuth {}'.format(oauth))
        return cls.VAULT_CLIENT


def get_yav_client(decode_files=True, oauth=None):
    return YavClientFabric.get_yav_client(decode_files, oauth)
