# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


class Endpoint(object):
    def __init__(self, endpoint_message, endpoint_set_label_selectors=None):
        self.message = endpoint_message
        if endpoint_set_label_selectors:
            self.labels = dict(zip(endpoint_set_label_selectors, self.message.label_selector_results))
        else:
            self.labels = {}

    def __getattr__(self, item):
        return getattr(self.message, item)

    def __repr__(self):
        return 'Endpoint({})'.format(self.message)
