# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from collections import defaultdict

from infra.yp_service_discovery.api import api_pb2
from infra.yp_service_discovery.python.resolver.resolver import Resolver


def resole_endpoint_sets(endpoint_sets_str, client_name, timeout=10):
    result = defaultdict(dict)
    resolver = Resolver(client_name=client_name, timeout=timeout)
    for endpoint_set_str in endpoint_sets_str:
        cluster, endpoint_set_id = endpoint_set_str.split('@')
        response = resolver.resolve_endpoints(api_pb2.TReqResolveEndpoints(
            cluster_name=cluster,
            endpoint_set_id=endpoint_set_id,
            client_name=client_name,
            label_selectors=['/labels/disable_search']
        ))
        result[cluster][endpoint_set_str] = response.endpoint_set.endpoints
    return result
