#pragma once

#include <kernel/querydata/idl/querydata_structs_client.pb.h>
#include <kernel/querydata/common/querydata_traits.h>

namespace NSaas {

    class TQueryDataReportBuilder {
    public:
        class TDocData {
        public:
            TDocData(NQueryData::TSourceFactors* sf)
                : Proto(*sf)
            {}

            void Add(const TString& name, const TString& data) {
                NQueryData::TFactor* factor = Proto.AddFactors();
                factor->SetName(name);
                factor->SetStringValue(data);
            }

            void AddTimestamp(ui64 ts) {
                Proto.SetVersion(ts);
            }

            void UpdateSourceKey(const TString& key) {
                Proto.SetSourceKey(key);
            }

        private:
            NQueryData::TSourceFactors& Proto;
        };

        TDocData AddDocumentMeta(const TString& key, const TString& ns) {
            NQueryData::TSourceFactors* sf = QDReport.AddSourceFactors();
            sf->SetSourceName(ns);
            sf->SetSourceKey(key);
            return TDocData(sf);
        }

        TDocData AddDocumentDataSet(const TString& key, const TString& ns, const TString& sourceName, NQueryData::EKeyType keyType) {
            NQueryData::TSourceFactors* sf = QDReport.AddSourceFactors();
            sf->SetTrieName(ns);
            sf->SetSourceName(sourceName);
            sf->SetSourceKey(key);
            sf->SetSourceKeyType(keyType);
            return TDocData(sf);
        }

        const NQueryData::TQueryData& GetFinalReport() {
            return QDReport;
        }

    private:
        NQueryData::TQueryData QDReport;
    };
}
