#pragma once

#include <util/generic/string.h>
#include <util/generic/vector.h>

class TRegexpToTrigrams {
    /**
        parsing re2 syntax
        https://github.com/google/re2/wiki/Syntax
        returns trigrams, which exactly have to exist in text
     */
public:
    TVector<TString> Parse(const TStringBuf& regexp);

private:
    void AddGarantedStringsWithoutBrackets(const TStringBuf& regexp);

    void AddGarantedStringsWithoutBracketsAndOr(const TStringBuf& regexp);

    TVector<TString> GetTrigramsFromGarantedStrings();

    TVector<TStringBuf> RemoveBracketsAndSpecSymbols(TStringBuf regexp);

private:
    TVector<TStringBuf> GarantedStrings;
};
