#pragma once

#include "abstract.h"

class TFakeReportContext: public IReportBuilderContext {
protected:
    const TCgiParameters& CgiParameters;
    TStringStream Report;
    TInstant RequestBeginTime;

public:
    TFakeReportContext(const TCgiParameters& cgiParameters)
        : CgiParameters(cgiParameters)
        , RequestBeginTime(Now())
    {
    }

    virtual const TCgiParameters& GetCgiParameters() const override {
        return CgiParameters;
    }

    virtual void MakeSimpleReply(const TBuffer& buf, int /*code*/ = HTTP_OK) override {
        Report << TStringBuf(buf.data(), buf.size());
    }

    const TString& GetReport() const {
        return Report.Str();
    }

    virtual const TSearchRequestData& GetRequestData() const override {
        FAIL_LOG("Not supported");
    }

    virtual const TRequestParams& GetRP() const override {
        FAIL_LOG("Not supported");
    }

    virtual TInstant GetRequestStartTime() const override {
        return RequestBeginTime;
    }

    virtual long GetRequestedPage() const override {
        return 0;
    }

    virtual void Print(const TStringBuf& data) override {
        Report << data;
    }

    virtual void AddReplyInfo(const TString& key, const TString& value) override {
        Y_UNUSED(key);
        Y_UNUSED(value);
        FAIL_LOG("Not implemented");
    }
};
