#pragma once

#include <saas/protos/rtyserver.pb.h>

#include <kernel/indexann/protos/data.pb.h>
#include <kernel/indexann_data/data.h>

#include <util/generic/array_ref.h>

namespace NIndexAnn {
    /// @brief Converts an annotation (one sentence) for SaaS
    bool UnpackToSaasData(NRTYServer::TMessage::TSentenceData& saasAnn, const NIndexAnn::TAnnotationRec& ann, const NIndexAnn::IFeaturesProfile& featuresFilter);

    /// @brief Converts multiple annotations for SaaS
    bool UnpackToSaasData(NRTYServer::TMessage::TAnnData& saasData, const NIndexAnn::TIndexAnnSiteData& annData, const NIndexAnn::IFeaturesProfile& featuresFilter);

    /// @brief Standard featuresFilter
    const NIndexAnn::IFeaturesProfile& GetSaasProfile();

    /// @brief An explicit list of Ann data streams supported by SaaS
    /// @deprecated
    const TArrayRef<const NIndexAnn::EDataType> GetSaasFeatures();
}
