#include "client.h"

namespace NRTYT {

    ::TIntrusivePtr<NYT::IYaMRReaderImpl> TClientBase::CreateYaMRReader(
        const NYT::TRichYPath& path,
        const NYT::TTableReaderOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(options);
        ythrow yexception() << "CreateYaMRReader: not implemented";
    }

    NYT::IFileReaderPtr TClientBase::CreateFileReader(
        const NYT::TRichYPath&,
        const NYT::TFileReaderOptions&) {
        return NYT::IFileReaderPtr();
    }

    NYT::IFileWriterPtr TClientBase::CreateFileWriter(
        const NYT::TRichYPath&,
        const NYT::TFileWriterOptions&) {
        return NYT::IFileWriterPtr();
    }

    NYT::TRawTableReaderPtr TClientBase::CreateRawReader(
        const NYT::TRichYPath& path,
        const NYT::TFormat& format,
        const NYT::TTableReaderOptions&) {
        Y_UNUSED(path);
        Y_UNUSED(format);
        ythrow yexception() << "CreateRawReader: not implemented";
    }

    NYT::TRawTableWriterPtr TClientBase::CreateRawWriter(
        const NYT::TRichYPath& path,
        const NYT::TFormat& format,
        const NYT::TTableWriterOptions&) {
        Y_UNUSED(path);
        Y_UNUSED(format);
        ythrow yexception() << "CreateRawWriter: not implemented";
    }

    NYT::IFileReaderPtr TClientBase::CreateBlobTableReader(
        const NYT::TYPath& path,
        const NYT::TKey& key,
        const NYT::TBlobTableReaderOptions&) {
        Y_UNUSED(path);
        Y_UNUSED(key);
        ythrow yexception() << "CreateBlobTableReader: not implemented";
    }

    NYT::IOperationPtr TClientBase::RawMap(
        const NYT::TRawMapOperationSpec& spec,
        ::TIntrusivePtr<NYT::IRawJob> mapper,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        Y_UNUSED(mapper);
        ythrow yexception() << "RawMap: not implemented";
    }

    NYT::IOperationPtr TClientBase::RawReduce(
        const NYT::TRawReduceOperationSpec& spec,
        ::TIntrusivePtr<NYT::IRawJob> reducer,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        Y_UNUSED(reducer);
        ythrow yexception() << "RawReduce: not implemented";
    }

    NYT::IOperationPtr TClientBase::DoJoinReduce(
        const NYT::TJoinReduceOperationSpec& spec,
        ::TIntrusivePtr<NYT::IStructuredJob> reducer,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        Y_UNUSED(reducer);
        ythrow yexception() << "DoJoinReduce: not implemented";
    }

    NYT::IOperationPtr TClientBase::RawJoinReduce(
        const NYT::TRawJoinReduceOperationSpec& spec,
        ::TIntrusivePtr<NYT::IRawJob> reducer,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        Y_UNUSED(reducer);
        ythrow yexception() << "RawJoinReduce: not implemented";
    }

    NYT::IOperationPtr TClientBase::DoMapReduce(
        const NYT::TMapReduceOperationSpec& spec,
        ::TIntrusivePtr<NYT::IStructuredJob> mapper,
        ::TIntrusivePtr<NYT::IStructuredJob> reduceCombiner,
        ::TIntrusivePtr<NYT::IStructuredJob> reducer,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        Y_UNUSED(mapper);
        Y_UNUSED(reduceCombiner);
        Y_UNUSED(reducer);
        ythrow yexception() << "DoMapReduce: not implemented";
    }

    NYT::IOperationPtr TClientBase::RawMapReduce(
        const NYT::TRawMapReduceOperationSpec& spec,
        ::TIntrusivePtr<NYT::IRawJob> mapper,
        ::TIntrusivePtr<NYT::IRawJob> reduceCombiner,
        ::TIntrusivePtr<NYT::IRawJob> reducer,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        Y_UNUSED(mapper);
        Y_UNUSED(reduceCombiner);
        Y_UNUSED(reducer);
        ythrow yexception() << "RawMapReduce: not implemented";
    }

    NYT::IOperationPtr TClientBase::Merge(
        const NYT::TMergeOperationSpec& spec,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        ythrow yexception() << "Merge: not implemented";
    }

    NYT::IOperationPtr TClientBase::Erase(
        const NYT::TEraseOperationSpec& spec,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        ythrow yexception() << "Erase: not implemented";
    }

    NYT::IOperationPtr TClientBase::RemoteCopy(
        const NYT::TRemoteCopyOperationSpec& spec,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        ythrow yexception() << "RemoteCopy: not implemented";
    }

    NYT::IOperationPtr TClientBase::RunVanilla(
        const NYT::TVanillaOperationSpec& spec,
        const NYT::TOperationOptions&) {
        Y_UNUSED(spec);
        ythrow yexception() << "RunVanilla: not implemented";
    }

    NYT::IOperationPtr TClientBase::AttachOperation(const NYT::TOperationId& operationId) {
        Y_UNUSED(operationId);
        return NYT::IOperationPtr();
    }

    NYT::EOperationBriefState TClientBase::CheckOperation(const NYT::TOperationId& operationId) {
        Y_UNUSED(operationId);
        return NYT::EOperationBriefState();
    }

    void TClientBase::AbortOperation(const NYT::TOperationId& operationId) {
        Y_UNUSED(operationId);
        return;
    }

    void TClientBase::CompleteOperation(const NYT::TOperationId& operationId) {
        Y_UNUSED(operationId);
        return;
    }

    void TClientBase::WaitForOperation(const NYT::TOperationId& operationId) {
        Y_UNUSED(operationId);
        return;
    }

    void TClientBase::AlterTable(
        const NYT::TYPath& path,
        const NYT::TAlterTableOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(options);
        return;
    }

    NYT::TBatchRequestPtr TClientBase::CreateBatchRequest() {
        return NYT::TBatchRequestPtr();
    }

    ::TIntrusivePtr<NYT::IYaMRWriterImpl> TClientBase::CreateYaMRWriter(
        const NYT::TRichYPath& path,
        const NYT::TTableWriterOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(options);
        ythrow yexception() << "CreateYaMRWriter: not implemented";
    }

    NYT::ITransactionPtr TClient::AttachTransaction(
        const NYT::TTransactionId& transactionId,
        const NYT::TAttachTransactionOptions& options) {
        Y_UNUSED(transactionId);
        Y_UNUSED(options);
        return MakeIntrusive<TTransaction>(*this);
    }

    void TClient::MountTable(
        const NYT::TYPath& path,
        const NYT::TMountTableOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }

    void TClient::UnmountTable(
        const NYT::TYPath& path,
        const NYT::TUnmountTableOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }

    void TClient::RemountTable(
        const NYT::TYPath& path,
        const NYT::TRemountTableOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }

    void TClient::FreezeTable(
        const NYT::TYPath& path,
        const NYT::TFreezeTableOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }
    void TClient::UnfreezeTable(
        const NYT::TYPath& path,
        const NYT::TUnfreezeTableOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }
    void TClient::ReshardTable(
        const NYT::TYPath& path,
        const TVector<NYT::TKey>& pivotKeys,
        const NYT::TReshardTableOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(pivotKeys);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }
    void TClient::ReshardTable(
        const NYT::TYPath& path,
        i64 tabletCount,
        const NYT::TReshardTableOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(tabletCount);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }

    void TClient::InsertRows(
        const NYT::TYPath& path,
        const NYT::TNode::TListType& rows,
        const NYT::TInsertRowsOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(rows);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }
    void TClient::DeleteRows(
        const NYT::TYPath& path,
        const NYT::TNode::TListType& keys,
        const NYT::TDeleteRowsOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(keys);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }
    void TClient::TrimRows(
        const NYT::TYPath& path,
        i64 tabletIndex,
        i64 rowCount,
        const NYT::TTrimRowsOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(tabletIndex);
        Y_UNUSED(rowCount);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }

    NYT::TNode::TListType TClient::LookupRows(
        const NYT::TYPath& path,
        const NYT::TNode::TListType& keys,
        const NYT::TLookupRowsOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(keys);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }
    NYT::TNode::TListType TClient::SelectRows(
        const TString& query,
        const NYT::TSelectRowsOptions& options) {
        Y_UNUSED(query);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "operations with dynamic tables not implemented";
    }

    void TClient::AlterTableReplica(
        const NYT::TReplicaId& replicaId,
        const NYT::TAlterTableReplicaOptions& options) {
        Y_UNUSED(replicaId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "AlterTableReplica: not implemented";
    }

    ui64 TClient::GenerateTimestamp() {
        return 0;
    }

    NYT::TAuthorizationInfo TClient::WhoAmI() {
        return NYT::TAuthorizationInfo();
    }

    NYT::TOperationAttributes TClient::GetOperation(
        const NYT::TOperationId& operationId,
        const NYT::TGetOperationOptions& options) {
        Y_UNUSED(operationId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "GetOperation: not implemented";
    }

    NYT::TListOperationsResult TClient::ListOperations(
        const NYT::TListOperationsOptions& options) {
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "ListOperations: not implemented";
    }

    void TClient::UpdateOperationParameters(
        const NYT::TOperationId& operationId,
        const NYT::TUpdateOperationParametersOptions& options) {
        Y_UNUSED(operationId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "UpdateOperationParameters: not implemented";
    }

    NYT::TJobAttributes TClient::GetJob(
        const NYT::TOperationId& operationId,
        const NYT::TJobId& jobId,
        const NYT::TGetJobOptions& options) {
        Y_UNUSED(operationId);
        Y_UNUSED(jobId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "GetJob: not implemented";
    }

    NYT::TListJobsResult TClient::ListJobs(
        const TOperationId& operationId,
        const NYT::TListJobsOptions& options) {
        Y_UNUSED(operationId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "ListJobs: not implemented";
    }

    NYT::IFileReaderPtr TClient::GetJobInput(
        const NYT::TJobId& jobId,
        const NYT::TGetJobInputOptions& options) {
        Y_UNUSED(jobId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "GetJobInput: not implemented";
    }

    NYT::IFileReaderPtr TClient::GetJobFailContext(
        const NYT::TOperationId& operationId,
        const NYT::TJobId& jobId,
        const NYT::TGetJobFailContextOptions& options) {
        Y_UNUSED(operationId);
        Y_UNUSED(jobId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "GetJobFailContext: not implemented";
    }

    NYT::IFileReaderPtr TClient::GetJobStderr(
        const NYT::TOperationId& operationId,
        const NYT::TJobId& jobId,
        const NYT::TGetJobStderrOptions& options) {
        Y_UNUSED(operationId);
        Y_UNUSED(jobId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "GetJobStderr: not implemented";
    }
    NYT::TNode::TListType TClient::SkyShareTable(
        const std::vector<NYT::TYPath>& tablePaths,
        const NYT::TSkyShareTableOptions& options) {
        Y_UNUSED(tablePaths);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "SkyShareTable: not implemented";
    }

    NYT::TCheckPermissionResponse TClient::CheckPermission(
        const TString& user,
        NYT::EPermission permission,
        const NYT::TYPath& path,
        const NYT::TCheckPermissionOptions& options) {
        Y_UNUSED(user);
        Y_UNUSED(permission);
        Y_UNUSED(path);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "CheckPermission: not implemented";
    }

    TVector<NYT::TTabletInfo> TClient::GetTabletInfos(
        const NYT::TYPath& path,
        const TVector<int>& tabletIndexes,
        const NYT::TGetTabletInfosOptions& options) {
        Y_UNUSED(path);
        Y_UNUSED(tabletIndexes);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "GetTabletInfos: not implemented";
    }
    void TClient::SuspendOperation(
        const NYT::TOperationId& operationId,
        const NYT::TSuspendOperationOptions& options) {
        Y_UNUSED(operationId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "SuspendOperation: not implemented";
    }

    void TClient::ResumeOperation(
        const NYT::TOperationId& operationId,
        const NYT::TResumeOperationOptions& options) {
        Y_UNUSED(operationId);
        Y_UNUSED(options);
        ythrow TWithBackTrace<yexception>() << "ResumeOperation: not implemented";
    }

}
