#include "cypress.h"

namespace NRTYT {

bool TCypressClient::CheckIfDirExistsCallback(TCypressClient* /*client*/, TCypressNodePtr node, const TString& child) {
    return (node->GetType() == ENodeType::NT_MAP && node->HasChild(child));
}

bool TCypressClient::CreateDirPathCallback(TCypressClient* client, TCypressNodePtr node, const TString& child) {
    if (node->HasChild(child)) {
        TCypressNodePtr tmpNode = client->NodeTree[node->GetChild(child)].Get();
        if (tmpNode->GetType() != NYT::NT_MAP) {
            return false;
        }
    } else {
        THolder<TCypressNode> newNode = client->CreateNode(child, NYT::NT_MAP);
        node->AddChild(newNode.Get());
        auto id = newNode->GetId();
        client->NodeTree[id] = std::move(newNode);
    }
    return true;
}


} // namespace NRTYT
