#include "node_table_reader.h"
#include <library/cpp/yson/node/node_io.h>

namespace NRTYT {

const NYT::TNode& TNodeReader::GetRow() const {
    return CurrentRow.GetRef();
}
void TNodeReader::MoveRow(NYT::TNode* row) {
    *row = std::move(CurrentRow.GetRef());
}

bool TNodeReader::IsValid() const {
    return RowId < Archive->GetDocsCount(false);
}

void TNodeReader::Next() {
    RowId++;
    if (IsValid()) {
        LoadCurrentRow();
    }
}
ui32 TNodeReader::GetTableIndex() const {
    return 0;
}
ui32 TNodeReader::GetRangeIndex() const {
    return 0;
}
ui64 TNodeReader::GetRowIndex() const {
    return RowId;
}
void TNodeReader::NextKey() {
}

void TNodeReader::LoadCurrentRow() {
    TBlob blob = Archive->GetDocument(RowId);
    CurrentRow = NYT::NodeFromYsonString(TString(blob.AsCharPtr(), blob.AsCharPtr() + blob.Length()));
}

} // namespace NRTYT
