#pragma once

#include "archive_config.h"

#include <mapreduce/yt/interface/io.h>
#include <kernel/multipart_archive/multipart.h>

namespace NRTYT {

class TNodeReader : public NYT::INodeReaderImpl {
public:
    TNodeReader(const TString& path)
        : ArchivePath(path) { // TODO: support ranges
        NRTYArchive::TMultipartConfig config = DefaultArchiveConfig;
        Archive = TArchiveOwner::Create(path, config);
        RowId = 0;
        if (IsValid()) {
            LoadCurrentRow();
        }
    }

    virtual const NYT::TNode& GetRow() const override;
    virtual void MoveRow(NYT::TNode* row) override;

public: // IReaderImplBase
    virtual bool IsValid() const override;
    virtual void Next() override;
    virtual ui32 GetTableIndex() const override;
    virtual ui32 GetRangeIndex() const override;
    virtual ui64 GetRowIndex() const override;
    virtual void NextKey() override;

private:
    TArchiveOwner::TPtr Archive;
    TString ArchivePath;
    TMaybe<NYT::TNode> CurrentRow;
    ui32 RowId;

    void LoadCurrentRow();
};

} // namespace NRTYT
